function [d loc] = get_ingle_data(outlierFlag)

if nargin < 1
    outlierFlag = 1;
end

addpath('data/')

%% load data

ingle = readtable('sample_data_11_14_Al_Be_only.xls');

%% unpack data

mask = table2array(ingle(:, 18));

id = table2cell(ingle(mask == outlierFlag, 1));
lat = table2array(ingle(mask == outlierFlag, 2));
lon = table2array(ingle(mask == outlierFlag, 3));
elv = table2array(ingle(mask == outlierFlag, 4));

transect = table2cell(ingle(mask == outlierFlag, 17));
group = table2cell(ingle(mask == outlierFlag, 16));
thick_cm = table2array(ingle(mask == outlierFlag, 6));
thick_gcm = thick_cm .* table2array(ingle(mask == outlierFlag, 7));
N10 = table2array(ingle(mask == outlierFlag, 10));
dN10 = table2array(ingle(mask == outlierFlag, 11));
N26 = table2array(ingle(mask == outlierFlag, 13));
dN26 = table2array(ingle(mask == outlierFlag, 14));

%% associate with each sample

for a = 1:length(id)
    
    % structure with location info
    this_loc.id = id{a};
    this_loc.transect = transect(a);
    this_loc.lat = lat(a);
    this_loc.lon = lon(a);
    this_loc.elv = elv(a);

    loc{a} = this_loc;
end

for a = 1:length(id)
    % structure with sample info
    this_s.id = id{a};
    this_s.transect = transect{a};
    this_s.group = group{a};
    this_s.thick_cm = thick_cm(a);
    this_s.thick_gcm = thick_gcm(a);
    this_s.N10 = N10(a);
    this_s.dN10 = dN10(a);
    this_s.N26 = N26(a);
    this_s.dN26 = dN26(a);
    this_s.deglac_t = get_deglac_t(loc{a});

    d{a} = this_s;
end

end